@extends('layouts.app')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="d-flex flex-column flex-column-fluid">
    <div id="kt_app_toolbar" class="app-toolbar pt-6 pb-2">
        <div id="kt_app_toolbar_container" class="app-container container-fluid d-flex align-items-stretch">
            <div class="app-toolbar-wrapper d-flex flex-stack flex-wrap gap-4 w-100">
                <div class="page-title d-flex flex-column justify-content-center gap-1 me-3">
                    <h1 class="page-heading d-flex flex-column justify-content-center text-gray-900 fw-bold fs-3 m-0">
                        {{ isset($devi) ? 'Modifier' : 'Créer' }} un devis
                    </h1>
                    <ul class="breadcrumb breadcrumb-separatorless fw-semibold fs-7 my-0">
                        <li class="breadcrumb-item text-muted">Espace administration</li>
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.devis.index') }}" class="text-muted text-hover-primary">Devis</a>
                        </li>
                        <li class="breadcrumb-item text-muted">{{ isset($devi) ? 'Modifier' : 'Créer' }}</li>
                    </ul>
                </div>
                <div class="d-flex align-items-center gap-2 gap-lg-3">
                    <a href="{{ route('admin.devis.index') }}" class="btn btn-flex btn-outline btn-color-gray-700 btn-active-color-primary bg-body h-40px fs-7 fw-bold">Liste</a>
                </div>
            </div>
        </div>
    </div>

    <div id="kt_app_content" class="app-content flex-column-fluid">


<div id="kt_app_content_container" class="app-container container-fluid">
            @if(session('success'))
                <div class="alert alert-success d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-shield-tick fs-2hx text-success me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-success">Succès</h4>
                        <span>{{ session('success') }}</span>
                    </div>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur</h4>
                        <span>{{ session('error') }}</span>
                    </div>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger d-flex align-items-center p-5 mb-10">
                    <i class="ki-outline ki-cross-circle fs-2hx text-danger me-4"></i>
                    <div class="d-flex flex-column">
                        <h4 class="mb-1 text-danger">Erreur de validation</h4>
                        <span>{{ $errors->first() }}</span>
                    </div>
                </div>
            @endif

            <!--begin::Form-->
            <form id="kt_ecommerce_add_category_form" class="form d-flex flex-column flex-lg-row" method="POST" action="{{ isset($devi) ? route('admin.devis.update', $devi) : route('admin.devis.store') }}" enctype="multipart/form-data">
                @csrf
                @if(isset($devi))
                    @method('PUT')
                    <input type="hidden" name="montant_ht" value="{{ $devi->total_ht }}">
                    <input type="hidden" name="montant_ht_original" value="{{ $devi->total_ht }}">
                @endif

                <div class="d-flex flex-column flex-xl-row">
                    <!-- Sidebar avec preview matériau -->
                    <div class="flex-column flex-lg-row-auto w-100 w-xl-350px mb-10">
                        <div id="recap-box" class="card mb-5 mb-xl-8">
                            <div class="card-body pt-8">
                                <div class="d-flex flex-center flex-column mb-5">
                                    <div class="image-input image-input-empty image-input-outline image-input-placeholder mb-3">
                                        <div class="image-input-wrapper w-150px h-150px">
                                            <img id="material-preview" src="{{ asset('assets/media/avatars/granit-noir-zimbabwe-extra.jpg') }}" width="150" style="max-width: 100%;" alt="Aperçu matériau">
                                        </div>
                                    </div>
                                    <div class="fs-3 text-gray-800 text-hover-primary fw-bold mb-1">
                                       <span id="material-name">{{ isset($devi) && $devi->matiere ? $devi->matiere->titre : '' }}</span> 
                                        <span id="colori-name">{{ isset($devi) && $devi->colori ? $devi->colori->titre : '' }}</span>
                                    </div>
                                </div>

                                <div class="separator separator-dashed my-3"></div>

                                <div id="kt_customer_view_details">
                                    <div class="fs-6">
                                        <div class="fw-bold mt-5">Finition</div>
                                        <div class="text-gray-600">
                                            <span id="finish-name">{{ isset($devi) && $devi->finition ? $devi->finition->titre : '' }}</span>
                                        </div>
                                    </div>

                                    <div class="fs-6">
                                        <div id="pdt-id" class="">

                                        </div>
                                    </div>

                                    <div class="fs-6">
                                            <span id="bordure-name"></span>
                                    </div>

                                    <div class="fs-6">
                                        <div id="credences-id">
                                            </div>
                                    </div>

                                    <div class="fs-6">
                                        <div id="options-id">
                                        </div>
                                    </div>

                                    <div class="fs-6">

                                        <div id="services-id">

                                        </div>
                                    </div>



                                    <div class="fs-6">
                                        <div class="fw-bold mt-5">Total HT</div>
                                        <div class="text-gray-600">
                                            <span id="total-amount">{{ isset($devi) ? number_format($devi->total_ht, 2, ',', ' ') : '0,00' }} €</span>
                                        </div>
                                    </div>

                                    <div class="fs-6">
                                        <div class="fw-bold mt-5">Total TTC - TVA : <span id="tva-id">{{ isset($devi) && $devi->tva == 10 ? '10%' : '20%' }}</span></div>
                                        <div class="text-gray-600">
                                             <span id="total-ttc">{{ isset($devi) ? number_format($devi->total_ht * (1 + ($devi->tva == 10 ? 0.1 : 0.2)), 2, ',', ' ') : '0,00' }} €</span>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Contenu principal avec accordion -->
                    <div class="flex-lg-row-fluid ms-lg-15">
                        <div class="card">
                            <div class="col-lg-12">

                            <div class="accordion" id="stepsdevis">

                              <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button collapsed accordion1" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    1- Merci de remplir le formulaire ci-dessous
                                  </button>
                                </h2>
                                <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">

                                      <div class="row">
                                            <div class="col-md-4">
                                                <div class="mb-10 fv-row">
                                                    <label for="addperc" class="required form-label">Pourcentage</label>
                                                    <input type="number" name="addperc" id="addperc" class="form-control mb-2" placeholder="Saisir un pourcentage entre 0 et 100" value="{{ isset($devi) ? $devi->addperc : old('addperc') }}" min="0" max="100" step="1" pattern="[0-9]+" oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0,3); if(parseInt(this.value) > 100) this.value = 100;" required="required" />
                                                    <div class="form-text">Valeur entière entre 0 et 100 (pas de virgules)</div>
                                                </div>
                                            </div>
                                          <div class="col-md-4">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-prenom" class="required form-label">Prenom</label>
                                                    <input type="text" name="client-prenom" id="client-prenom" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->prenom : old('client-prenom') }}" required="required" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-nom" class="required form-label">Nom</label>
                                                    <input type="text" id="client-nom" name="client-nom" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->nom : old('client-nom') }}" required="required" />
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-email" class="required form-label">Email</label>
                                                    <input type="email" id="client-email" name="client-email" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->email : old('client-email') }}" required="required" />
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-tel" class="required form-label">Telephone</label>
                                                    <input type="tel" id="client-tel" name="client-tel" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->telephone : old('client-tel') }}" required="required" />
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="mb-10 fv-row">
                                                    <label class="form-label">Adresse</label>
                                                    <textarea required="required" type="text" name="client-adresse" class="form-control mb-2">{{ isset($devi) && $devi->client ? $devi->client->adresse : old('client-adresse') }}</textarea>
                                                </div>
                                            </div>

                                            <div class="col-md-4">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-pays" class="required form-label">Pays</label>
                                                    <input type="text" id="client-pays" name="client-pays" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->pays ?? 'France' : old('client-pays', 'France') }}" required="required" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-ville" class="required form-label">Ville</label>
                                                    <input type="text" name="client-ville" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->ville : old('client-ville') }}" required="required" />
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="mb-10 fv-row">
                                                    <label for="client-cp" class="required form-label">Code postal</label>
                                                    <input type="text" id="client-cp" name="client-cp" class="form-control mb-2" placeholder="" value="{{ isset($devi) && $devi->client ? $devi->client->code_postal : old('client-cp') }}" required="required" />
                                                </div>
                                            </div>
                                        </div>	

                                      <div class="d-flex justify-content-end mt-10">
                                          <button id="step1" type="button" class="nextstep btn btn-primary">
                                              <span class="indicator-label">Suivant | -></span>

                                          </button>
                                      </div>

                                </div>
                                </div>
                              </div>
                              <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button accordion2" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="true" aria-controls="collapseTwo">
                                    2- Selectionnez les matériaux de votre plan de travail
                                  </button>
                                </h2>
                                <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">


                                      <div class="mb-10 row">
                                            <div class="col-md-4">
                                                <label for="matiere_id" class="required form-label">Matière</label>
                                                <select id="matiere_id" name="matiere_id" class="form-select"  data-control="select2" required>
                                                    <option value="">Sélectionner une matière</option>
                                                    @foreach($matieres as $matiere)
                                                        <option value="{{ $matiere->id }}" {{ (isset($devi) && $devi->matiere_id == $matiere->id) ? 'selected' : '' }}>
                                                            {{ $matiere->titre }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('matiere_id')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-md-4">
                                                <label for="colori_id" class="required form-label">Coloris</label>
                                                <select id="colori_id" name="colori_id" class="form-select" data-control="select2" required>
                                                    <option value="">Sélectionner un coloris</option>
                                                    @foreach($coloris as $colori)
                                                        <option value="{{ $colori->id }}" {{ (isset($devi) && $devi->colori_id == $colori->id) ? 'selected' : '' }}>
                                                            {{ $colori->titre }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('colori_id')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>

                                            <div class="col-md-4">
                                                <label for="finition_id" class="required form-label">Finition</label>
                                                <select id="finition_id" name="finition_id" class="form-select" data-control="select2" required>
                                                    <option value="">Sélectionner une finition</option>
                                                    @foreach($finitions as $finition)
                                                        <option value="{{ $finition->id }}" {{ (isset($devi) && $devi->finition_id == $finition->id) ? 'selected' : '' }}>
                                                            {{ $finition->titre }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('finition_id')
                                                    <div class="text-danger">{{ $message }}</div>
                                                @enderror
                                            </div>
                                        </div>


                                      <div class="d-flex justify-content-end mt-10">
                                            <button type="button" class="nextstep btn btn-primary">
                                                <span class="indicator-label">Suivant | -></span>

                                            </button>
                                        </div>
                                </div>
                                </div>
                              </div> 

                              <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button collapsed accordion3" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    3- Indiquez la taille de votre plan de travail
                                  </button>
                                </h2>
                                <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">
                                  <div id="plans-container">
                                      <div class="mb-10 row">

                                          <!--begin::Repeater-->
                                      <div class="class_repeat" id="kt_docs_repeater_plantravail">
                                          <!--begin::Form group-->
                                          <div class="form-group">
                                              <div data-repeater-list="kt_docs_repeater_plantravail">
                                                  @if(isset($devi) && $devi->prixcoloris->where('type', 'pldt')->count() > 0)
                                                      @foreach($devi->prixcoloris->where('type', 'pldt') as $plan)
                                                          <div data-repeater-item class="mb-5">
                                                              <div class="form-group row">
                                                                  <div class="col-md-3">
                                                                      <label id="longueur" class="form-label">Longueur mm: </label>
                                                                      <input name="pl-longueur" required type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="longueur" value="{{ $plan->longeur }}" />
                                                                  </div>

                                                                  <div class="col-md-3">
                                                                      <label for="largeur" class="form-label">Largeur mm: </label>
                                                                      <input name="pl-largeur" required type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="largeur" value="{{ $plan->largeur }}" />
                                                                  </div>
                                                                  <div class="col-md-3">
                                                                      <label for="pl-epaisseur" class="form-label">Épaisseur: </label>
                                                                      <select required name="pl-epaisseur" class="epaisseur form-select dimension-input" data-hide-search="true" data-control="" data-dimension="epaisseur" data-selected="{{ $plan->prixcolori_id }}">
                                                                          <option value="">Choisissez une épaisseur</option>
                                                                      </select>
                                                                  </div>
                                                                  <div class="col-md-3">
                                                                      <a href="javascript:;" data-repeater-delete class="btn btn-sm btn-light-danger mt-3 mt-md-8">
                                                                          <i class="ki-duotone ki-trash fs-5"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
                                                                      </a>
                                                                  </div>
                                                              </div>
                                                          </div>
                                                      @endforeach
                                                  @else
                                                      <div data-repeater-item class="mb-5">
                                                          <div class="form-group row">
                                                              <div class="col-md-3">
                                                                  <label id="longueur" class="form-label">Longueur mm: </label>
                                                                  <input name="pl-longueur" id="pl-longueur" required type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="longueur" />
                                                              </div>

                                                              <div class="col-md-3">
                                                                  <label for="largeur" class="form-label">Largeur mm: </label>
                                                                  <input name="pl-largeur" id="pl-largeur" required type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="largeur" />
                                                              </div>
                                                              <div class="col-md-3">
                                                                  <label for="pl-epaisseur" class="form-label">Épaisseur: </label>
                                                                  <select required name="pl-epaisseur" class="epaisseur form-select dimension-input" data-hide-search="true" data-control="" data-dimension="epaisseur">
                                                                      <option value="">Choisissez une épaisseur</option>
                                                                  </select>
                                                              </div>
                                                              <div class="col-md-3">
                                                                  <a href="javascript:;" data-repeater-delete class="btn btn-sm btn-light-danger mt-3 mt-md-8">
                                                                      <i class="ki-duotone ki-trash fs-5"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
                                                                  </a>
                                                              </div>
                                                          </div>
                                                      </div>
                                                  @endif
                                              </div>
                                          </div>
                                          <!--end::Form group-->

                                          <!--begin::Form group-->
                                          <div class="row">
                                          <div class="col-12 mt-5">
                                          <div class="form-group">
                                              <a href="javascript:;" data-repeater-create class="btn btn-light-primary">
                                                  <i class="ki-duotone ki-plus fs-3"></i>
                                                  Ajouter une autre taille
                                              </a>
                                          </div></div></div>
                                          <!--end::Form group-->
                                      </div>
                                      <!--end::Repeater-->



                                      </div>
                                </div>
                                      <div class="d-flex justify-content-end mt-10">
                                            <button type="button" class="nextstep btn btn-primary">
                                                <span class="indicator-label">Suivant | -></span>

                                            </button>
                                        </div>
                                </div>
                                </div>
                              </div>

                              <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button collapsed accordion4" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                    4- Selectionnez la forme de bordure de votre plan de travail
                                  </button>
                                </h2>
                                <div id="collapseFour" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">

                                      <div class="mb-10 row">
                                      <div class="col-md-7">
                                          <label class="required form-label">Chant plan de travail</label>
                                           <select id="bordure_id" name="bordure_id" class="form-select" data-hide-search="true" required="required">
                                              <option value="">Sélectionner une bordure</option>
                                              @foreach($bordures as $bordure)
                                                  <option value="{{ $bordure->id }}" 
                                                          data-photo="{{ $bordure->photo ? asset('storage/' . $bordure->photo) : '' }}"
                                                          data-prix="{{ $bordure->prix }}"
                                                          {{ (isset($devi) && $devi->bordure_id == $bordure->id) ? 'selected' : '' }}>
                                                          {{ $bordure->titre }} - <span class="bordure-prix-{{ $bordure->id }}">{{ number_format($bordure->prix, 2) }}</span>€
                                                      </option>
                                              @endforeach
                                          </select>

                                      </div>
                                      <div class="col-md-5">
                                          <div class="symbol symbol-100px mb-7">
                                              <img id="bordureimage" src="{{ isset($devi) && $devi->bordure && $devi->bordure->photo ? asset('storage/' . $devi->bordure->photo) : asset('assets/media/avatars/chant-droit-biseaute.jpg') }}" alt="image">
                                          </div>
                                      </div>

                                      </div>
                                      <div class="d-flex justify-content-end mt-10">
                                            <button type="button" class="nextstep btn btn-primary">
                                                <span class="indicator-label">Suivant | -></span>

                                            </button>
                                        </div>
                                </div>
                                </div>
                              </div>


                             <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button collapsed accordion5" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                    5- Ajouter une crédence
                                  </button>
                                </h2>
                                <div id="collapseFive" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">
                                  <div id="credences-container">
                                      <div class="mb-10 row">

                                          <!--begin::Repeater-->
                                      <div class="class_repeat" id="kt_docs_repeater_credence">
                                          <!--begin::Form group-->
                                          <div class="form-group">
                                              <div data-repeater-list="kt_docs_repeater_credence">

                                                  @if(isset($devi) && $devi->prixcoloris->where('type', 'credence')->count() > 0)
                                                      @foreach($devi->prixcoloris->where('type', 'credence') as $credence)

                                                          <div data-repeater-item class="mb-5">
                                                              <div class="form-group row">
                                                                  <div class="col-md-3">
                                                                      <label class="form-label">Longueur mm:</label>
                                                                      <input name="credence_longueur" type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="credence_longueur" value="{{ $credence->longeur }}" />
                                                                  </div>

                                                                  <div class="col-md-3">
                                                                      <label class="form-label">Largeur mm:</label>
                                                                      <input name="credence_largeur" type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="credence_largeur" value="{{ $credence->largeur }}" />
                                                                  </div>
                                                                  <div class="col-md-3">
                                                                      <label class="form-label">Épaisseur:</label>
                                                                      <select name="credence_epaisseur" class="epaisseur form-select dimension-input" data-hide-search="true" data-control="select2" data-dimension="epaisseur" data-selected="{{ $credence->prixcolori_id }}">
                                                                          <option value="">Choisissez une épaisseur</option>
                                                                      </select>
                                                                  </div>
                                                                  <div class="col-md-3">
                                                                      <a href="javascript:;" data-repeater-delete class="btn btn-sm btn-light-danger mt-3 mt-md-8">
                                                                          <i class="ki-duotone ki-trash fs-5"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
                                                                      </a>
                                                                  </div>
                                                              </div>
                                                          </div>
                                                      @endforeach
                                                  @else
                                                      <div data-repeater-item class="mb-5">
                                                          <div class="form-group row">
                                                              <div class="col-md-3">
                                                                  <label class="form-label">Longueur mm:</label>
                                                                  <input  name="credence_longueur" type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="credence_longueur" />
                                                              </div>

                                                              <div class="col-md-3">
                                                                  <label class="form-label">Largeur mm:</label>
                                                                  <input  name="credence_largeur" type="number" class="form-control mb-2 mb-md-0 dimension-input" data-dimension="credence_largeur" />
                                                              </div>
                                                              <div class="col-md-3">
                                                                  <label class="form-label">Épaisseur:</label>
                                                                  <select  name="credence_epaisseur" class="epaisseur form-select dimension-input" data-hide-search="true" data-control="select2" data-dimension="epaisseur">
                                                                        <option value="">Choisissez une épaisseur</option>
                                                                    </select>
                                                              </div>
                                                              <div class="col-md-3">
                                                                  <a href="javascript:;" data-repeater-delete class="btn btn-sm btn-light-danger mt-3 mt-md-8">
                                                                      <i class="ki-duotone ki-trash fs-5"><span class="path1"></span><span class="path2"></span><span class="path3"></span><span class="path4"></span><span class="path5"></span></i>
                                                                  </a>
                                                              </div>
                                                          </div>
                                                      </div>
                                                  @endif
                                              </div>
                                          </div>
                                          <!--end::Form group-->

                                          <!--begin::Form group-->
                                          <div class="form-group mt-5">
                                              <a href="javascript:;" data-repeater-create class="btn btn-light-primary">
                                                  <i class="ki-duotone ki-plus fs-3"></i>
                                                   Ajouter une autre credence
                                              </a>
                                          </div>
                                          <!--end::Form group-->
                                      </div>
                                      <!--end::Repeater-->



                                      </div>
                                </div>
                                      <div class="d-flex justify-content-end mt-10">
                                            <button type="button" class="nextstep btn btn-primary">
                                                <span class="indicator-label">Suivant | -></span>

                                            </button>
                                        </div>
                                </div>
                                </div>
                              </div>

                              <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button collapsed accordion6" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                    6- Choisissez les options et découpes de votre plan de travail
                                  </button>
                                </h2>
                                <div id="collapseSix" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">

                                      <div class="mb-10 row">


                                          @if($optionsdecoupes->count() > 0)
                                              @foreach($optionsdecoupes as $optionsdecoupe)
                                                  @php
                                                      $selectedQuantity = 0;
                                                      if(isset($devi)) {
                                                          $deviOption = $devi->optionsdecoupes->where('optionsdecoupe_id', $optionsdecoupe->id)->first();
                                                          $selectedQuantity = $deviOption ? $deviOption->quantite : 0;
                                                      }
                                                  @endphp
                                                  <div class="col-md-3 mb-5 text-center">
                                                      <div class="symbol symbol-100px mb-7">
                                                          <img src="{{ $optionsdecoupe->photo ? asset('storage/' . $optionsdecoupe->photo) : asset('assets/media/avatars/bbb.jpg') }}" alt="{{ $optionsdecoupe->titre }}">
                                                      </div>
                                                      <div class="form-label">{{ $optionsdecoupe->titre }}</div>
                                                      <div class="text-muted fs-7 mb-3">{{ number_format($optionsdecoupe->prix, 2) }}€</div>
                                                      <div style="width: 70px; margin: auto;">
                                                          <select class="form-select form-select-sm optionsdecoupe-quantity" 
                                                                  data-option-id="{{ $optionsdecoupe->id }}" 
                                                                  data-prix="{{ $optionsdecoupe->prix }}"
                                                                  name="optionsdecoupes[{{ $optionsdecoupe->id }}]">
                                                              <option value="0" {{ $selectedQuantity == 0 ? 'selected' : '' }}>0</option>
                                                              <option value="1" {{ $selectedQuantity == 1 ? 'selected' : '' }}>1</option>
                                                              <option value                                                              <option value="2" {{ $selectedQuantity == 2 ? 'selected' : '' }}>2</option>
                                                              <option value="3" {{ $selectedQuantity == 3 ? 'selected' : '' }}>3</option>
                                                              <option value="4" {{ $selectedQuantity == 4 ? 'selected' : '' }}>4</option>
                                                              <option value="5" {{ $selectedQuantity == 5 ? 'selected' : '' }}>5</option>
                                                          </select>
                                                      </div>
                                                  </div>
                                              @endforeach
                                          @else
                                              <div class="col-12 text-center text-muted">Aucune option de découpe disponible</div>
                                          @endif


                                      </div>
                                      <div class="d-flex justify-content-end mt-10">
                                            <button type="button" class="nextstep btn btn-primary">
                                                <span class="indicator-label">Suivant | -></span>

                                            </button>
                                        </div>
                                </div>
                                </div>
                              </div>
                              <div class="accordion-item">
                                <h2 class="accordion-header">
                                  <button class="accordion-button collapsed accordion7" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSeven" aria-expanded="false" aria-controls="collapseSeven">
                                    7- Selectionnez nos services
                                  </button>
                                </h2>
                                <div id="collapseSeven" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                  <div class="accordion-body">

                                      <div class="row">
                                          @if($services->count() > 0)
                                              @foreach($services as $service)
                                                  <div class="col-md-6">
                                                      <div class="mb-10">
                                                          <label class="form-check form-check-custom form-check-solid fs-5">
                                                              <input class="form-check-input h-30px w-30px service-checkbox" 
                                                                     type="checkbox" 
                                                                     value="{{ $service->id }}"
                                                                     data-prix="{{ $service->prix }}"
                                                                     name="services[{{ $service->id }}]"
                                                                     {{ isset($devi) && $devi->services->contains('service_id', $service->id) ? 'checked' : '' }}/>
                                                              <span class="form-check-label text-body">{{ $service->titre }}</span>
                                                              <span class="form-check-label text-success fw-bold ms-2">: {{ number_format($service->prix, 2) }}€</span>
                                                          </label>
                                                      </div>
                                                  </div>
                                              @endforeach
                                          @else
                                              <div class="col-12 text-center text-muted">Aucun service disponible</div>
                                          @endif
                                      </div>

                                      <div class="d-flex justify-content-end mt-10">
                                            <button type="button" class="nextstep btn btn-primary">
                                                <span class="indicator-label">Suivant | -></span>

                                            </button>
                                        </div>
                                </div>
                                </div>
                              </div>



                                <div class="accordion-item">
                                    <h2 class="accordion-header">
                                      <button class="accordion-button collapsed accordion8" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEight" aria-expanded="false" aria-controls="collapseEight">
                                        8- TVA
                                      </button>
                                    </h2>
                                    <div id="collapseEight" class="accordion-collapse collapse" data-bs-parent-kha="#stepsdevis">
                                      <div class="accordion-body">

                                          <div class="mb-10">
                                                             <label class="form-check form-check-custom form-check-solid fs-5">
                                            <input class="form-check-input h-30px w-30px" name="tva" type="checkbox" value="1" {{ isset($devi) && $devi->tva == 10 ? 'checked' : '' }}/>
                                                                          <span class="form-check-label text-body">Habitation de plus de 2 ans TVA à 10%</span>
                                                                      </label>
                                                                      <label class="form-check-label text-gray-600 text-body" style="margin-left: 37px">TVA à 10% applicable aux logements à usage d'habitation de plus de 2 ans si l'installation est réalisée par nos soins, si non TVA à 20%</label>
                                                                  </div>


                                    </div>
                                    </div>
                                  </div>
                                </div>



                            </div>

                                    </div>
                                <!--end::Accordion-->

                                <!-- Boutons d'action -->
                                <div class="d-flex justify-content-end mt-10">
                                    <a href="{{ route('admin.devis.index') }}" class="btn btn-light me-5">Annuler</a>
                                    <button type="submit" class="btn btn-primary">
                                        <span class="indicator-label">{{ isset($devi) ? 'Modifier' : 'Créer' }} le devis</span>
                                        <span class="indicator-progress">Veuillez patienter... 
                                            <span class="spinner-border spinner-border-sm align-middle ms-2"></span>
                                        </span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
<script src="/assets/plugins/custom/formrepeater/formrepeater.bundle.js"></script>
<script src="/assets/js/devis.js"></script>

@if(isset($devi))
<script>
    $(".accordion-button").attr("aria-disabled", false).attr("disabled", false);
</script>
@endif
  <script src="https://cdn.jsdelivr.net/npm/sticky-sidebar@3.3.1/dist/sticky-sidebar.min.js"></script>
<script>
  var sidebar = new StickySidebar('#recap-box', {
    containerSelector: '.row', // ou ton conteneur principal
    innerWrapperSelector: '.inner-wrapper', // à ajouter dans ton recap box
    topSpacing: 20,
    bottomSpacing: 20
  });
</script>

@endsection